DROP PROCEDURE IF EXISTS sp_mostrarStockProductos;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_mostrarStockProductos`(IN `p_idProducto` INT, IN `p_idClase` INT, IN `p_idSubcategoria` INT, IN `p_indicador` VARCHAR(100), IN `p_fechaInicio` DATETIME, IN `p_fechaFin` DATETIME, IN `p_tipoOperacion` INT)
BEGIN     
    IF p_tipoOperacion = 1 THEN 		
        CREATE TEMPORARY TABLE STOCK_TEMP as (
			SELECT idProducto, nombreProducto,DNA.cantidadTotal,
				SUM( CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal 
					ELSE 0.00 END) AS cantidadEntrada,
				SUM( CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal 
				ELSE 0.00 END) AS cantidadSalida,
				DNA.unidadMedida
			FROM DETALLE_NOTA_ALMACEN DNA
			INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen 
			WHERE date(NA.fechaEmision) BETWEEN p_fechaInicio AND p_fechaFin
				AND NA.estado = 'C'
			GROUP BY DNA.idProducto  -- , DNA.nombreProducto, DNA.unidadMedida
		);
    
    
		CREATE TEMPORARY TABLE REPORTE_TEMP as (
			SELECT 
				P.idProducto,
				CONCAT(C.abreviatura, P.codigo) AS codigo,
				P.nombre,
				CA.idCategoria,
				CA.nombre as 'categoria',
				S.idSubCategoria,
				S.nombre as 'subcategoria',
				P.idClase,            
				C.nombre as 'clase',
				P.marca,
				P.modelo,
				P.medida,
				P.cod_fab,
				P.stockMin, ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) as stockActual, 
				P.unidad_medida, M.descripcion as unidadMedida, P.tipo_existencia, M2.descripcion as tipoExistencia,
		
				(CASE WHEN P.activo = 1 THEN 'SI' 
					WHEN P.activo = 0 THEN 'NO' 
				END) AS activo,
				CASE 
					WHEN P.stockMin = 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) < P.stockMin then 'BAJO' 
					WHEN P.stockMin = 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) >= P.stockMin and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) <= 5 then 'MEDIO' 
					WHEN P.stockMin = 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) > 5 then 'ALTO' 
					WHEN P.stockMin > 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) <= P.stockMin then 'BAJO' 
					WHEN P.stockMin > 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) > P.stockMin and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) <= 1.5*P.stockMin THEN 'MEDIO'
					WHEN P.stockMin > 0 and ifnull(ST.cantidadEntrada - ST.cantidadSalida,0.00) >= 1.5*P.stockMin THEN 'ALTO'                
				END AS 'indicador'
			FROM PRODUCTO P
            LEFT JOIN STOCK_TEMP ST ON ST.idProducto = P.idProducto
			INNER JOIN CLASE C ON C.idClase = P.idClase and (C.idClase = p_idClase or '0' = p_idClase)
			INNER JOIN SUBCATEGORIA S ON S.idSubcategoria = C.idSubcategoria and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
			INNER JOIN CATEGORIA CA ON CA.idCategoria = S.idCategoria
			INNER JOIN MULTITABLA M ON M.abrev = P.unidad_medida and M.dep_id = 3
			INNER JOIN MULTITABLA M2 ON M2.abrev = P.tipo_existencia and M2.dep_id = 14
		);
        
        SELECT * FROM REPORTE_TEMP WHERE (indicador = p_indicador or p_indicador = '0') ORDER BY nombre;
        
        drop temporary table STOCK_TEMP;
        drop temporary table REPORTE_TEMP;
	END IF; 
END
$